// Postfix calculator

#import <stdio.h>
#import <Foundation/Foundation.h>
#import "StackOfInteger.h"
#import "PostfixCalculator.h"
#import "NSString+Reversible.h"


int main (int argc, char *argv[])
{
    // Illustrating the implicit creation of an object using a directive
   
    //////////////////// Working with Stacks of integers ///////////////////////////////
    
    printf("Working with Stacks of integers\n");
    // Creating a StackOfInt using the alloc and an init method
    StackOfInteger *myStack = [[StackOfInteger alloc] init];
    [myStack push2:25 another:255];    
    int intValue1 = [myStack pop]; 
    int intValue2 = myStack.pop;
    // int intValue2 = [myStack pop];
    printf("First value is >%d< Second value is >%d<\n", intValue1,intValue2);

    printf("Done working with Stacks of integers\n");

    ///////////////////Working with Postfix calculator /////////////////////////
    
    printf("Working with Postfix calculators\n");
    
    // Creating a Postfix Calculator using the alloc and a custom init method
    PostfixCalculator *myCalculatorWithInit = 
        [[PostfixCalculator alloc] initWithExpression:@"44 55 *"];
    
    // Creating a Postfix Calculator using a class method, also known as a Factory method
    PostfixCalculator *myCalculator = [PostfixCalculator CreateWithExpression:@"44 55 *"];
    
    // Are these two calculators equal?
    
    // Using a PostfixCalculator
    NSString * myExpression = [myCalculator getExpression];
    NSLog(@"Expression >%@<", myExpression);
    myExpression = myCalculator->expression;
    NSLog(@"Expression accessed directly>%@<", myExpression);
    int result = [myCalculator calculate];
    printf("result >%d<\n", result);
    NSLog (@"%d", result);
    
    printf("Done working with Postfix calculator\n");
    
    ////////////////// Creating objects through compiler directives /////////////
    
    NSString* aStringObject = @"This is a C String";
    NSLog(@"Printing aStringObject>%@<", aStringObject);
    
    /////////////////////////////// Using properties /////////////////////////
    [myStack push2:251 another:2555];
    printf("Count of elements %d\n", [myStack stackPointer]);
    printf("Count of elements using dot notation %d\n", myStack.stackPointer);
    // [myStack setStackPointer:40];retString
    
  //////////////////////////////// Using categories ///////////////////////////////// 
    
    NSLog(@"Printing reversed string>%@<", [aStringObject reverse]);

   //////////////////////////////// Using protocols //////////////////////////////////
   
    printf("Testing conformance to protocols\n");
    if ([myStack conformsToProtocol:@protocol(Printable)]) { 
       printf("Using protocol methods\n");
       [myStack printMe];
      // NSLog(@"String representation of the stack >%@<\n", [myStack printMeToString]);
    } else {
       NSLog(@"Object does not conform to protocol %@\n", @protocol(Printable));  
    }   
   

    id someObject = [[PostfixCalculator alloc] initWithExpression:@"44 55 *"];
    if (![someObject conformsToProtocol:@protocol(Printable)]) { 
       NSLog(@"Object does not conform to protocol");  
    } 
    
    ///////////////// Introspection ///////////////

    printf("Getting the class and super class of an object\n");
    StackOfInteger *aStack = [[StackOfInteger alloc] init];    
    NSLog(@"Class is %@, and super is %@.", [aStack class], [aStack superclass]);
    
    printf("Calling a method of a class object using @selector\n");
    Class postfixCalculatorClass = [someObject class];
    [postfixCalculatorClass performSelector:@selector(printClassDescription)];
    
    printf("Calling a method of a class object given a string\n");
    SEL printClassDescriptionSEL = NSSelectorFromString(@"printClassDescription");
    [postfixCalculatorClass performSelector:printClassDescriptionSEL];

    return 0;
}